/******************************************************************************/
class SetPointLight : BaseEvent
{
public:
            SetPointLight();
   virtual ~SetPointLight();
   
   virtual void create(Object &obj); 
   virtual void AfterCreate(      );
   
private:

   virtual void CallTriggeredAction();
   virtual void StopTriggeredAction();
   
   // Light
   UID m_LightUID;
   VarPointLight* m_VarLight;
   
   // Light variables to set
   UID m_PowerUID, m_VolUID, m_VolMaxUID, m_PosUID, m_ColorUID;
   
   VarFloat* m_VarPower, *m_VarVol, *m_VarVolMax;
   VarVec* m_VarPos, *m_VarColor;
};
/******************************************************************************/
SetPointLight::SetPointLight() : BaseEvent(), m_VarLight(null), m_VarPower(null), m_VarVol(null), m_VarVolMax(null), m_VarPos(null), m_VarColor(null) 
{
   
}
SetPointLight::~SetPointLight()
{
   
}
/******************************************************************************/
void SetPointLight::create(Object &obj)
{
   // Getting the parameters from the object in the world
   if(Param *p = obj.findParam("VarPointLightUID"))  m_LightUID  = p.asID();
   if(Param *p = obj.findParam("PowerVarFloatUID"))  m_PowerUID  = p.asID();
   if(Param *p = obj.findParam("VolVarFloatUID"))    m_VolUID    = p.asID();
   if(Param *p = obj.findParam("VolMaxVarFloatUID")) m_VolMaxUID = p.asID();
   if(Param *p = obj.findParam("PosVarVecUID"))      m_PosUID    = p.asID();
   if(Param *p = obj.findParam("ColorVarVecUID"))    m_ColorUID  = p.asID();
   
   super.create(obj); // Create the BaseEvent params too
}
/******************************************************************************/
void SetPointLight::AfterCreate()
{
   // Find the correct Vars to work on. This has to be done here, because it's unreliable during create() (not all objects are loaded yet)
   REPA(variablesPointLight)
      if(variablesPointLight[i].id() == m_LightUID)
         m_VarLight = &variablesPointLight[i];
         
   DEBUG_ASSERT(m_VarLight, "VarPointLight not found in scene");
         
   REPA(variablesFloat)
   {
      if(variablesFloat[i].id() == m_PowerUID)
         m_VarPower = &variablesFloat[i]; 
         
      if(variablesFloat[i].id() == m_VolUID)
         m_VarVol = &variablesFloat[i]; 
         
      if(variablesFloat[i].id() == m_VolMaxUID)
         m_VarVolMax = &variablesFloat[i]; 
   }
   
   REPA(variablesVec)
   {
      if(variablesVec[i].id() == m_PosUID)
         m_VarPos = &variablesVec[i];
         
      if(variablesVec[i].id() == m_ColorUID)
         m_VarColor = &variablesVec[i];
   }
          
}
/******************************************************************************/
// This method is called when the event was triggered, taking the delay into account
void SetPointLight::CallTriggeredAction()
{
   if(m_LogDetailed || m_LogOutput)
   {
      //LogN(S+"Start Trigger: Setting VarBool (INFO: " + m_EditorInfo + " ) from: " + m_VarBool->GetValue() + ", to: " + m_Value);
   }
   
   if(m_PowerUID != UIDZero)
      m_VarLight->SetPower(m_VarPower->GetValue());
      
   if(m_VolUID != UIDZero)
      m_VarLight->SetVol(m_VarVol->GetValue());
      
   if(m_VolMaxUID != UIDZero)
      m_VarLight->SetVolMax(m_VarVolMax->GetValue());
      
   if(m_PosUID != UIDZero)
      m_VarLight->SetPos(m_VarPos->GetValue());
      
   if(m_ColorUID != UIDZero)
      m_VarLight->SetColor(m_VarColor->GetValue());
}

// This method is called when the duration of the event has been reached
void SetPointLight::StopTriggeredAction()
{
   if(m_LogDetailed || m_LogOutput)
   {
      //LogN(S+" Stop Trigger: Setting VarBool (INFO: " + m_EditorInfo + " ) from: " + m_VarBool->GetValue() + ", to: " + m_OrigValue);
   }
   
   // If m_Duration is not -1, the bool will be set back to its original value, after a while
   //m_VarLight->SetValue(m_OrigValue); 
}
/******************************************************************************/